$Ontext
The code solves the problem for a single TMDL (not the whole range) to get the
detail data on each problem solution.

The code solves te deterministic trading problem for Mercury.
The choice is between a set of possible treatment options and the option of
trading.
The details of the three treatement technologies are:
1. Coagulation and Filteration
2. Activated Carbon
3. Ion Exchange
The code takes the value of TMDL and does the rest of the calculations automatically.
This will be used to see the variations of the results with TMDL changes.
The code also considers the health cost for the humans. So an increased TMDL
results in an increased value of the health. The health cost is derived from the
WQS, the resulting conc. of Hg in fishes, the LC50 value for the aquatic life
(assumed to be close to that of humans) and the dietary intake of fish by humans.
$offtext

Sets i Number of industries /1*29/
     j Number of treatment options /1*3/
     alias(i,k);

Parameter TMDL Total Maximum Daily Load /32/
         HSC Highest Segment Concentration (ng per lit) /5.0/
         CAL Current Annual Load (Kilograms per year) /58.8/

         r trading ratio /1.1/
         F trading transaction cost (dollars per Kg) /400000000/

         TC Plant costs for the three technologies /1 1.0,2 1.55,3 0.65/
         q Reductions possible by the treatment technologies /1 2,2 3,3 1/

         water_intake Intake of water by an average individual per day in liters /2.0/
         fish_intake Intake of fish food by an everage individual in kg per day /0.0175/
         safe_hg Safe concentration of Hg in fishes in mg per kg /0.4/
         LC50 The LC50 value of HG (taken from fishes) in micrograms per liter /350/

         Compensation Compensation for each dead person in dollar /1000000/
         population total population consuming the water /10000/;


Table Data Date related to the industries
*Data(i,1) is the total volumetric discharge in MGD
*Data(i,2) is the current discharge concentration in nanograms/liter
*Data(i,3) is the available capital with the industry in Million Dollars
         1       2       3
1        46.1    4.65    68
2        1.5     3.7     8
3        4.6     4.3     15
4        1.5     3.4     5
5        2       3.88    10
6        2.24    3.7     12
7        1.2     3.9     9
8        27      4.83    30
9        4.5     4.0     15
10       1       3.1     5
11       1       3.06    5
12       1       3.22    5
13       2       3.31    9
14       3.765   4.8     10
15       18      4.33    60
16       7.2     5.1     20
17       58.6    4.87    100
18       23      4.52    40
19       1.152   5.05    10
20       0.362   4.14    5
21       108     4.58    130
22       4.68    5.2     12
23       28.09   4.41    45
24       1.921   3.9     10
25       0.544   4.5     7
26       0.5     3.95    10
27       0.003   3.72    5
28       1.246   4.1     5
29       0.054   3.4     3;


scalar k1 conversion from gallons to liters /3.7845/
       k2 scalar used as a couter;

Parameter cost cost incurred by each industry due to waste treatment setup
         cost_total The total overall cost incurred which is to be minimized
         cost_combined Combined cost including the technology cost and health care cost
         cost_health The actual health cost incurred due to the pollutant discharge
         target_reduction The total reduction from all the industries targetted
         red_final Final reduction in the discharge achieved by each industry after optimization
         red_total The final combined reduction from the industries
         WQS Water Quality Standard (ng per lit)
         WQS_final Final water standard achieved after reduction
         WQS_avg The average WQS for the industries after the reduction
         reduction Desired reduction in Kg per year
         mortality The number of people dying due to the contamination

         Tech_cost cost incurred by each industry due to waste treatment setup
         Tech_cost_total The total overall cost incurred which is to be minimized

         Results To store and display the final results;

Parameter v
          u;

WQS=(HSC/CAL)*TMDL;
reduction(i,'1')=(Data(i,'2')-WQS)*Data(i,'1')*k1*10**(-6)*365;

binary variables b binary variable specifying the process selection;

variable t Variable deciding the amount of mercury traded between various industries
         Tobj Objective function
         obj Objective function;

*===============================================================================
* First solving the Technology only model to generate constraints for the problem
* The constraint states that no industry should be required to spend more as a results
* of trading.
* Definig the Technology only problem
Equations Tobjective
         Tc1
         Tc3;

Tobjective.. Tobj =e=1000*365*sum((i,j),TC(j)*Data(i,'1')*b(i,j));
Tc1(i)..  sum(j,b(i,j)) =l= 3;
Tc3(i).. 10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b(i,j)) =g= reduction(i,'1');
* The reduction constraint is multiplied by 1000 on both sides to avoid
* numerical errors arising due to small values.

model Tech_problem /Tobjective, Tc1, Tc3/;






*===============================================================================

* Definig the Trading option problem
Equations objective
         c1
         c3
         c4
         c5
         c6;

objective.. obj =e= 1000*365*sum((i,j),TC(j)*Data(i,'1')*b(i,j));
c1(i)..  sum(j,b(i,j)) =l= 3;
c3(i).. t(i,i) =e= 0;
c4(i).. 10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b(i,j))+(sum(k,t(i,k))-r*sum(k,t(k,i))) =g= reduction(i,'1');
* Expressing the trading and reduction quantities in grams/year to incerase absolute values
c5(i).. Tech_cost(i) =g= 1000*365*sum(j,b(i,j)*Data(i,'1')*TC(j))+F*(sum(k,t.l(i,k))-sum(k,t.l(k,i)))/1000;
c6(i).. 10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b(i,j))+(sum(k,t(i,k))-r*sum(k,t(k,i))) =g= 0;
t.lo(i,k) = 0;

model problem /objective,c1, c3, c4, c5, c6/;

*=== Solving the Technology only problem to generate constraint for the main problem===
options Optcr=0.001;
solve Tech_problem using mip minimizing Tobj;

Tech_cost(i)=1000*365*sum(j,b.l(i,j)*Data(i,'1')*TC(j));
Tech_cost_total=sum(i,Tech_cost(i));
*===============================================================================

options Optcr=0.001;
solve problem using mip minimizing obj;









target_reduction=sum(i,reduction(i,'1'));

*===============================================================================
red_final(i,'1')=10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b.l(i,j))+(sum(k,t.l(i,k))-r*sum(k,t.l(k,i)));
red_total=sum(i,red_final(i,'1'));
* In grams/year

cost(i,'1')=1000*365*sum(j,b.l(i,j)*Data(i,'1')*TC(j))+F*(sum(k,t.l(i,k))-sum(k,t.l(k,i)))/1000;
cost_total=sum(i,cost(i,'1'));
*===============================================================================
u(i,k)=t.l(k,i);

* Calculation of the actual health care cost after the actual discharges are known from the solution
WQS_final(i,'1')=Data(i,'2')-red_final(i,'1')/(Data(i,'1')*k1*10**(-6)*365);
* The second term in this equation converts the final reduction in the units of micro-grams/liter.
* The Data(i,'2') is also in same units so the WQS_final is also in micro-grams/liter.

WQS_avg=sum(i,WQS_final(i,'1')*(Data(i,'1')*k1*10**(-6)*365))/sum(i,(Data(i,'1')*k1*10**(-6)*365));
mortality=((WQS_avg*safe_hg/2.8)*fish_intake*1000*0.5*population/(LC50*water_intake));

cost_health=mortality*compensation;
cost_combined=cost_total+cost_health;

v=sum((i,k), t.l(i,k));

Results('1','1')=red_total;
Results('1','2')=cost_health;
Results('1','3')=cost_total;
Results('1','4')=cost_combined;
Results('1','5')=v;

display WQS, red_final,WQS_final, b.l, Results, cost, t.l;
